define(['angular', 'app', 'CustomMessagesService'], function (angular, app) {
	'use strict';
	app.controller('CustomMessagesController', function ($scope, $http, $q, CustomMessagesService, focusService,
														 modalService, connectionErrorService, activeInstitution) {
		focusService.focusMain();

		$scope.institution = activeInstitution.divisionName;
		$scope.site = activeInstitution.childName;
 		$scope.customMessages = {customMessages:[{}]};
		$scope.messageDisplayArray = [
			{
			 	messageId:'appointmentNoPreferredDatePopup',
			 	maxLength:250,
				page:"New Appointment/Request",
				field:"Select Date/Time – Don’t see a date or time that works for you (Pop-Up Content)"
			},
			{
				messageId:'noClinicRadioButtons',
				maxLength:250,
				page:"New Appointment/Request",
				field:"Clinic"
			}
		];

		$scope.groupedMessageDisplayArray = _.groupBy($scope.messageDisplayArray,'page');

    CustomMessagesService.fetch(activeInstitution.childName).then(function(response) {
    	if (response.status !== 200) {
      	return connectionErrorService.showServerErrorMsg(response);
      }
      //return the currentMessage status
      $scope.customMessages = response.data;
			if ($scope.customMessages.userFriendlyText === '' || !$scope.customMessages.userFriendlyText){
				$scope.userFriendlyText = activeInstitution.divisionName;
				$scope.customLocation = activeInstitution.divisionName;
			} else{
				$scope.userFriendlyText = $scope.customMessages.userFriendlyText;
				$scope.customLocation = $scope.customMessages.userFriendlyText;
			}

			if ($scope.customMessages.customMessages.length <= 0) {
				$scope.customMessages.customMessages = [{ messageId : 'appointmentNoPreferredDatePopup', messageText : ''}];
			}

    });

		var modalOptions = {
			actionButtonText: 'OK',
			headerText: 'Confirmation',
			bodyText: 'Your text has been saved.'
		};

		$scope.findMessage = function(messageId) {
			//pass in the message ID, return the message from the collection.
			var messageIndex = _.findIndex($scope.customMessages.customMessages, function(customMessage){
						return customMessage.messageId == messageId;
			});
			return $scope.customMessages.customMessages[messageIndex];
		};

    $scope.save = function(e) {
			var fDNS   troller = this.customMessagesForm;
			fDNS   troller.$setSubmitted();
			fDNS   troller.validationSummary.validate().then(function() {
				var httpRequestPromise;
				$scope.customMessages.userFriendlyText = $scope.userFriendlyText;
				CustomMessagesService.save($scope.customMessages,activeInstitution.childName).then(function(response) {
					$scope.customMessages = response.data;
					// update form state
					fDNS   troller.$setPristine();
					fDNS   troller.validationSummary.clear();

				  modalService.showModal({}, modalOptions).then(function() {
						focusService.focusPrimary();
					});
				});
				fDNS   troller.validationSummary.summarizeAsync([httpRequestPromise]);
			});
		};

		$scope.friendlyRestoreDefault = function(e) {
			var fDNS   troller = this.customMessagesForm;
			$scope.userFriendlyText = activeInstitution.divisionName;
			fDNS   troller.$setDirty();
		};

		$scope.restoreDefault = function(e, messageId) {
			var fDNS   troller = this.customMessagesForm;
			var message = $scope.findMessage(messageId);
			CustomMessagesService.fetchDefault(messageId).then(function(response) {
					angular.copy(response.data, message);
					fDNS   troller.$setDirty();
			});
		};
	});
});
